/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.lens.Lens;

public class LensFlare
extends Lens {
    @Override
    public boolean allowBurstShooting(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        return false;
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        if (!redstone) {
            this.emitParticles(stack, spreader);
        }
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, IManaSpreader spreader) {
        this.emitParticles(stack, spreader);
    }

    private void emitParticles(ItemStack stack, IManaSpreader spreader) {
        float rotationYaw = -(spreader.getRotationX() + 90.0f);
        float rotationPitch = spreader.getRotationY();
        float f = 0.3f;
        float mx = (float)((double)(Mth.m_14031_((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        float mz = (float)((double)(-(Mth.m_14089_((float)(rotationYaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(rotationPitch / 180.0f * (float)Math.PI)) * f)) / 2.0);
        float my = (float)((double)(Mth.m_14031_((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        int storedColor = ItemLens.getStoredColor(stack);
        int hex = -1;
        Level level = spreader.getManaReceiverLevel();
        if (storedColor == 16) {
            hex = Mth.m_14169_((float)((float)(level.m_46467_() * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f);
        } else if (storedColor >= 0) {
            hex = ColorHelper.getColorValue(DyeColor.m_41053_((int)storedColor));
        }
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        WispParticleData data = WispParticleData.wisp(0.4f, r, g, b);
        BlockPos pos = spreader.getManaReceiverPos();
        level.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.5 + (double)mx * 4.5, (double)pos.m_123342_() + 0.5 + (double)my * 4.5, (double)pos.m_123343_() + 0.5 + (double)mz * 4.5, (double)mx, (double)my, (double)mz);
    }
}

